<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="mb-0">
        <i class="bi bi-plus-circle me-2"></i>Buat Biodata / CV
    </h2>
    <a href="<?= base_url('admin/dashboard') ?>" class="btn btn-secondary">
        <i class="bi bi-arrow-left me-1"></i>Kembali ke Dashboard
    </a>
</div>

<?php if (session()->getFlashdata('errors')): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <ul class="mb-0">
            <?php foreach (session()->getFlashdata('errors') as $error): ?>
                <li><?= $error ?></li>
            <?php endforeach; ?>
        </ul>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<div class="admin-card">
    <form action="<?= base_url('admin/biodata/store') ?>" method="POST" enctype="multipart/form-data">
        <?= csrf_field() ?>
        
        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="nama_lengkap" class="form-label">Nama Lengkap <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="nama_lengkap" name="nama_lengkap" 
                       value="<?= old('nama_lengkap') ?>" required>
            </div>
            <div class="col-md-6 mb-3">
                <label for="nama_panggilan" class="form-label">Nama Panggilan</label>
                <input type="text" class="form-control" id="nama_panggilan" name="nama_panggilan" 
                       value="<?= old('nama_panggilan') ?>">
            </div>
        </div>

        <div class="row">
            <div class="col-md-4 mb-3">
                <label for="tempat_lahir" class="form-label">Tempat Lahir</label>
                <input type="text" class="form-control" id="tempat_lahir" name="tempat_lahir" 
                       value="<?= old('tempat_lahir') ?>">
            </div>
            <div class="col-md-4 mb-3">
                <label for="tanggal_lahir" class="form-label">Tanggal Lahir</label>
                <input type="date" class="form-control" id="tanggal_lahir" name="tanggal_lahir" 
                       value="<?= old('tanggal_lahir') ?>">
            </div>
            <div class="col-md-4 mb-3">
                <label for="jenis_kelamin" class="form-label">Jenis Kelamin</label>
                <select class="form-select" id="jenis_kelamin" name="jenis_kelamin">
                    <option value="">Pilih</option>
                    <option value="L" <?= old('jenis_kelamin') === 'L' ? 'selected' : '' ?>>Laki-laki</option>
                    <option value="P" <?= old('jenis_kelamin') === 'P' ? 'selected' : '' ?>>Perempuan</option>
                </select>
            </div>
        </div>

        <div class="mb-3">
            <label for="alamat" class="form-label">Alamat</label>
            <textarea class="form-control" id="alamat" name="alamat" rows="3"><?= old('alamat') ?></textarea>
        </div>

        <div class="row">
            <div class="col-md-4 mb-3">
                <label for="kota" class="form-label">Kota</label>
                <input type="text" class="form-control" id="kota" name="kota" value="<?= old('kota') ?>">
            </div>
            <div class="col-md-4 mb-3">
                <label for="provinsi" class="form-label">Provinsi</label>
                <input type="text" class="form-control" id="provinsi" name="provinsi" value="<?= old('provinsi') ?>">
            </div>
            <div class="col-md-4 mb-3">
                <label for="kode_pos" class="form-label">Kode Pos</label>
                <input type="text" class="form-control" id="kode_pos" name="kode_pos" value="<?= old('kode_pos') ?>">
            </div>
        </div>

        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="no_telepon" class="form-label">No. Telepon</label>
                <input type="text" class="form-control" id="no_telepon" name="no_telepon" value="<?= old('no_telepon') ?>">
            </div>
            <div class="col-md-6 mb-3">
                <label for="email" class="form-label">Email</label>
                <input type="email" class="form-control" id="email" name="email" value="<?= old('email') ?>">
            </div>
        </div>

        <div class="row">
            <div class="col-md-4 mb-3">
                <label for="website" class="form-label">Website</label>
                <input type="url" class="form-control" id="website" name="website" value="<?= old('website') ?>">
            </div>
            <div class="col-md-4 mb-3">
                <label for="linkedin" class="form-label">LinkedIn</label>
                <input type="url" class="form-control" id="linkedin" name="linkedin" value="<?= old('linkedin') ?>">
            </div>
            <div class="col-md-4 mb-3">
                <label for="github" class="form-label">GitHub</label>
                <input type="url" class="form-control" id="github" name="github" value="<?= old('github') ?>">
            </div>
        </div>

        <div class="mb-3">
            <label for="instagram" class="form-label">Instagram</label>
            <input type="url" class="form-control" id="instagram" name="instagram" value="<?= old('instagram') ?>">
        </div>

        <div class="mb-3">
            <label for="foto_profil" class="form-label">Foto Profil</label>
            <input type="file" class="form-control" id="foto_profil" name="foto_profil" 
                   accept="image/jpeg,image/png,image/gif">
            <small class="text-white">Format: JPG, PNG, GIF (Max: 2MB)</small>
        </div>

        <div class="mb-3 position-relative">
            <label for="tentang_saya" class="form-label">Tentang Saya</label>
            <textarea class="form-control" id="tentang_saya" name="tentang_saya" rows="5" 
                      placeholder="Deskripsi tentang diri Anda akan diisi otomatis oleh AI atau Anda bisa menulis sendiri..."><?= old('tentang_saya') ?></textarea>
            
            <!-- AI Generate Button -->
            <button type="button" class="btn btn-outline-primary btn-sm position-absolute ai-generate-btn" 
                    style="top: 35px; right: 10px; z-index: 10;" 
                    id="generateProfileBtn" onclick="generateBiodataProfile()">
                <i class="bi bi-magic" id="generateProfileIcon"></i>
                <span id="generateProfileText">Generate AI</span>
            </button>
            
            <!-- AI Status -->
            <div class="ai-status mt-2" id="aiProfileStatus" style="display: none;">
                <div class="alert alert-info alert-sm">
                    <i class="bi bi-robot me-1"></i>
                    <span id="aiProfileStatusText">Tunggu sebentar yahh..</span>
                </div>
            </div>
        </div>

        <div class="mb-3 position-relative">
            <label for="keahlian" class="form-label">Keahlian</label>
            <textarea class="form-control" id="keahlian" name="keahlian" rows="3" 
                      placeholder="Contoh: PHP, JavaScript, HTML, CSS, MySQL"><?= old('keahlian') ?></textarea>
        </div>

        <div class="mb-3 position-relative">
            <label for="deskripsi_lengkap" class="form-label">Deskripsi Lengkap</label>
            <textarea class="form-control" id="deskripsi_lengkap" name="deskripsi_lengkap" rows="6" 
                      placeholder="Deskripsi lengkap tentang latar belakang, pengalaman, dan tujuan karir Anda akan diisi otomatis oleh AI atau Anda bisa menulis sendiri..."><?= old('deskripsi_lengkap') ?></textarea>
            
            <!-- AI Generate Button -->
            <button type="button" class="btn btn-outline-primary btn-sm position-absolute ai-generate-btn" 
                    style="top: 35px; right: 10px; z-index: 10;" 
                    id="generateDescriptionBtn" onclick="generateBiodataDescription()">
                <i class="bi bi-magic" id="generateDescIcon"></i>
                <span id="generateDescText">Generate AI</span>
            </button>
            
            <!-- AI Status -->
            <div class="ai-status mt-2" id="aiDescStatus" style="display: none;">
                <div class="alert alert-info alert-sm">
                    <i class="bi bi-robot me-1"></i>
                    <span id="aiDescStatusText">Tunggu sebentar yahh..</span>
                </div>
            </div>
        </div>

        <div class="d-flex gap-2">
            <button type="submit" class="btn btn-primary">
                <i class="bi bi-save me-1"></i>Simpan
            </button>
            <a href="<?= base_url('admin/dashboard') ?>" class="btn btn-secondary">
                <i class="bi bi-x me-1"></i>Batal
            </a>
        </div>
    </form>
</div>
<?= $this->endSection() ?>


<?= $this->section('scripts') ?>
<script>
// AI Profile Generator for Biodata
function generateBiodataProfile() {
    const namaLengkap = document.getElementById('nama_lengkap').value;
    const keahlian = document.getElementById('keahlian').value;
    
    if (!namaLengkap.trim()) {
        showAlert('Nama lengkap harus diisi terlebih dahulu!', 'warning');
        document.getElementById('nama_lengkap').focus();
        return;
    }
    
    // Show loading state
    const btn = document.getElementById('generateProfileBtn');
    const icon = document.getElementById('generateProfileIcon');
    const text = document.getElementById('generateProfileText');
    const status = document.getElementById('aiProfileStatus');
    
    btn.disabled = true;
    icon.className = 'spinner-border spinner-border-sm';
    text.textContent = 'Tunggu sebentar yahh..';
    status.style.display = 'block';
    document.getElementById('aiProfileStatusText').textContent = 'Tunggu sebentar yahh.. AI sedang bekerja...';
    
    // Prepare data
    const formData = new FormData();
    formData.append('nama_lengkap', namaLengkap);
    formData.append('keahlian', keahlian);
    formData.append('pendidikan', 'Mahasiswa Ilmu Komputer');
    formData.append('pengalaman', 'Web Development, Mobile Development, AI');
    
    // Call AI API
    fetch('<?= base_url('api/ai/generate-biodata-profile') ?>', {
        method: 'POST',
        body: formData,
        headers: {
            'X-Requested-With': 'XMLHttpRequest'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            document.getElementById('tentang_saya').value = data.text;
            showAlert('Profil singkat berhasil digenerate oleh AI!', 'success');
            document.getElementById('aiProfileStatusText').textContent = 'Profil berhasil digenerate!';
            
            // Auto hide status after 3 seconds
            setTimeout(() => {
                status.style.display = 'none';
            }, 3000);
        } else {
            showAlert('Gagal generate profil: ' + data.message, 'danger');
            document.getElementById('aiProfileStatusText').textContent = 'Gagal generate: ' + data.message;
        }
    })
    .catch(error => {
        showAlert('Terjadi kesalahan: ' + error.message, 'danger');
        document.getElementById('aiProfileStatusText').textContent = 'Terjadi kesalahan!';
    })
    .finally(() => {
        // Reset button state
        btn.disabled = false;
        icon.className = 'bi bi-magic';
        text.textContent = 'Generate AI';
    });
}

// AI Description Generator for Biodata
function generateBiodataDescription() {
    const namaLengkap = document.getElementById('nama_lengkap').value;
    const keahlian = document.getElementById('keahlian').value;
    
    if (!namaLengkap.trim()) {
        showAlert('Nama lengkap harus diisi terlebih dahulu!', 'warning');
        document.getElementById('nama_lengkap').focus();
        return;
    }
    
    // Show loading state
    const btn = document.getElementById('generateDescriptionBtn');
    const icon = document.getElementById('generateDescIcon');
    const text = document.getElementById('generateDescText');
    const status = document.getElementById('aiDescStatus');
    
    btn.disabled = true;
    icon.className = 'spinner-border spinner-border-sm';
    text.textContent = 'Tunggu sebentar yahh..';
    status.style.display = 'block';
    document.getElementById('aiDescStatusText').textContent = 'Tunggu sebentar yahh.. AI sedang bekerja...';
    
    // Prepare data
    const formData = new FormData();
    formData.append('nama_lengkap', namaLengkap);
    formData.append('keahlian', keahlian);
    formData.append('pendidikan', 'Mahasiswa Ilmu Komputer di Universitas Yatsi Madani');
    formData.append('pengalaman', 'Freelance Editor, Guru Kejuruan TKJ, Web Development, Mobile Development');
    formData.append('minat', 'Web Development, Mobile Development, AI, Machine Learning, UI/UX Design');
    
    // Call AI API
    fetch('<?= base_url('api/ai/generate-biodata-description') ?>', {
        method: 'POST',
        body: formData,
        headers: {
            'X-Requested-With': 'XMLHttpRequest'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            document.getElementById('deskripsi_lengkap').value = data.text;
            showAlert('Deskripsi lengkap berhasil digenerate oleh AI!', 'success');
            document.getElementById('aiDescStatusText').textContent = 'Deskripsi berhasil digenerate!';
            
            // Auto hide status after 3 seconds
            setTimeout(() => {
                status.style.display = 'none';
            }, 3000);
        } else {
            showAlert('Gagal generate deskripsi: ' + data.message, 'danger');
            document.getElementById('aiDescStatusText').textContent = 'Gagal generate: ' + data.message;
        }
    })
    .catch(error => {
        showAlert('Terjadi kesalahan: ' + error.message, 'danger');
        document.getElementById('aiDescStatusText').textContent = 'Terjadi kesalahan!';
    })
    .finally(() => {
        // Reset button state
        btn.disabled = false;
        icon.className = 'bi bi-magic';
        text.textContent = 'Generate AI';
    });
}

// Alert function
function showAlert(message, type) {
    const alertDiv = document.createElement('div');
    alertDiv.className = `alert alert-${type} alert-dismissible fade show`;
    alertDiv.innerHTML = `
        ${message}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    `;
    
    // Insert at top of form
    const form = document.querySelector('form');
    form.parentNode.insertBefore(alertDiv, form);
    
    // Auto remove after 5 seconds
    setTimeout(() => {
        if (alertDiv.parentNode) {
            alertDiv.remove();
        }
    }, 5000);
}
</script>
<?= $this->endSection() ?>
